<?php

namespace App\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Company extends Model 
{

    protected $table = 'companies';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'address', 'city_id', 'owner', 'phone');
    protected $visible = array('name', 'address', 'city_id', 'owner', 'phone');

    public function city()
    {
        return $this->belongsTo('App\Entities\City');
    }

    public function products()
    {
        return $this->hasMany('App\Entities\Product');
    }

    public function users()
    {
        return $this->morphMany('App\Entities\User');
    }

}